import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import RSVP from 'rsvp';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

function setupButtonState(self, context) {
  self.register('service:premium-geo', Service.extend({
    showPrimeContent: context.prime || false,
    getGeo() { return RSVP.resolve({ geo: 'US' }); }
  }));
  self.register('service:session', Service.extend({
    userData: {
      isAuthenticated: !!context.isAuthenticated,
      has_premium: context.prime || false
    }
  }));
  self.set('named', context.named || false);
  self.set('channel', {
    isSubscribed: context.isAuthenticated ? undefined : {
      content: !context.subscribed ? [] : [{
          product: {
            period: context.subPeriod || 'Month'
          },
          purchase_profile: {
            payment_provider: context.primeSub ? 'samus' : 'xsolla'
          }
      }],
      isLoading: false,
      isLoaded: true
    },
    displayName: 'testChannelName',
    product: {
      price: '4.99',
      isLoaded: true
    }
  });
  self.render(hbs`{{subscribe-button channel=channel named=named}}`);
}

moduleForComponent('subscribe-button', 'Integration | Component | subscribe-button', {
  integration: true
});

test('it renders the subscribed button', function(assert) {
  setupButtonState(this, {
    subscribed: true
  });
  assert.elementText(this.$(), 'Subscribed');
});

test('it renders the subscribed button with a name', function(assert) {
  setupButtonState(this, {
    subscribed: true,
    named: true
  });
  assert.elementText(this.$(), 'Subscribed to testChannelName');
});

test('it renders the old subscribe button', function(assert) {
  assert.expect(2);
  setupButtonState(this, {
    prime: false
  });
  assert.elementText(this.$('.js-old-subscribe-text'), 'Subscribe');
  assert.elementText(this.$('.js-old-subscribe-price'), '4.99');
});

test('it renders the old subscribe button with a name', function(assert) {
  assert.expect(2);
  setupButtonState(this, {
    prime: false,
    named: true
  });
  assert.elementText(this.$('.js-old-subscribe-text'), 'Subscribe to testChannelName');
  assert.elementText(this.$('.js-old-subscribe-price'), '4.99');
});

test('it renders the dynamic subscribe button', function(assert) {
  setupButtonState(this, {
    prime: true
  });
  assert.elementCount(this.$('.js-subscribe-button-dynamic'), 1);
});

test('it renders the resubscribe button', function(assert) {
  assert.expect(2);
  setupButtonState(this, {
    prime: true,
    subscribed: true,
    primeSub: true
  });
  assert.elementCount(this.$('.js-resubscribe-button'), 1);
  assert.elementText(this.$('.js-subscribe-text'), 'Subscribed');
});

test('it renders the subscribed button for prime sub to permanent ticket', function(assert) {
  assert.expect(2);
  setupButtonState(this, {
    prime: true,
    subscribed: true,
    primeSub: true,
    subPeriod: 'One Time'
  });
  assert.elementText(this.$(), 'Subscribed');
  assert.elementCount(this.$('.js-resubscribe-button'), 0);
});

test('it renders the subscribe button for anonymous user in prime geo', function(assert) {
  assert.expect(1);
  setupButtonState(this, {
    isAuthenticated: false,
    prime: true
  });
  assert.elementCount(this.$('.js-subscribe-button-dynamic'), 1);
});

test('it renders the old subscribe button for anonymous user in non-prime geo', function(assert) {
  assert.expect(2);
  setupButtonState(this, {
    isAuthenticated: false,
    prime: false
  });
  assert.elementText(this.$('.js-old-subscribe-text'), 'Subscribe');
  assert.elementText(this.$('.js-old-subscribe-price'), '4.99');
});
