import hbs from 'htmlbars-inline-precompile';
import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import wait from 'ember-test-helpers/wait';

moduleForComponent('subscribe-button/dynamic', 'Integration | Component | subscribe-button/dynamic');

test('it renders dynamic subscribe button', function(assert) {
  this.render(hbs`{{subscribe-button/dynamic}}`);

  return wait().then(() => {
    assert.elementCount(this.$('.js-subscribe-button-dynamic'), 1);
  });
});

test('displays subscription modal when clicked', function(assert) {
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/dynamic
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  return wait().then(() => {
    this.$('.js-sub-button').click();
    return wait();
  }).then(() => {
    assert.elementCount($('.js-subscribtion-modal'), 1);
  });
});

test('closes subscription modal when clicking outside the modal', function(assert) {
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/dynamic
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  return wait().then(() => {
    this.$('.js-sub-button').click();
    return wait();
  }).then(() => {
    assert.elementCount($('.js-subscribtion-modal'), 1);
    return wait();
  }).then(() => {
    $('body').click();
    return wait();
  }).then(() => {
    assert.elementCount($('.js-subscribtion-modal'), 0);
  });
});

test('coming from premium welcome page', function(assert) {
  this.set('urlParams', { expandsubmodal: true });

  assert.expect(1);

  this.render(hbs`{{subscribe-button/dynamic urlParams=urlParams}}`);

  return wait().then(() => {
    assert.elementCount($('.js-subscribtion-modal'), 1, 'Modal is opened if coming from premium welcome page');
  });
});
