import { test } from 'ember-qunit';
import EmberObject from 'ember-object';
import wait from 'ember-test-helpers/wait';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('subscribe-button/modal', 'Integration | Component | subscribe-button/modal', {
  integration: true,

  beforeEach() {
    this.notify = this.owner.lookup('service:notify');
    this.inject.service('premium-welcome-actions', {as: 'premiumWelcomeActions'});
  }
});

test('without prime renders `try prime`', function(assert) {
  this.render(hbs`{{subscribe-button/modal}}`);
  assert.elementCount(this.$('.js-samus-trial-text'), 1);
});

test('with prime renders `subscription price`', function(assert) {
  this.render(hbs`{{subscribe-button/modal hasPrime=true hasSubCredit=1}}`);
  assert.elementCount(this.$('[data-samus-subscribe-text]'), 1);
});

test('Can subscribe with prime credit', function(assert) {
  assert.expect(1);
  let channel = EmberObject.extend({
    id: '1',
    isSubscribed: {
      isSubscribed: false
    }
  });

  this.set('isSubscribing', false);
  this.set('setIsSubscribing', (value = false) => {
    this.set('isSubscribing', value);
  });

  this.set('toggle', () => {});
  this.set('toggleHasSubscribedMessage', () => {});
  this.set('channel', channel.create());
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/modal
                    hasPrime=true
                    hasSubCredit=1
                    channel=channel
                    isSubscribing=isSubscribing
                    setIsSubscribing=(action setIsSubscribing)
                    toggle=toggle
                    toggleHasSubscribedMessage=toggleHasSubscribedMessage
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  this.$('[data-samus-subscribe-text]').click();

  return wait().then(() => {
    assert.equal(this.get('channel.isSubscribed.isSubscribed'), true, 'Subscription was successful');
  });
});

test('display error message when subscribing returns a server error', function(assert) {
  assert.expect(5);
  let channel = EmberObject.extend({
    id: '1',
    isSubscribed: {
      isSubscribed: false
    }
  });

  this.server.post('https://api.twitch.tv/api/premium/credit/spend', function() {
    assert.ok(true, 'an error is expected');
  }, 500);

  this.set('setIsSubscribing', () => {});
  this.set('channel', channel.create());
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/modal
                    hasPrime=true
                    hasSubCredit=1
                    channel=channel
                    setIsSubscribing=(action setIsSubscribing)
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  assert.equal(this.notify._invocations.length, 0, 'there are no errors');

  this.$('[data-samus-subscribe-text]').click();

  return wait().then(() => {
    assert.equal(this.notify._invocations.length, 1, 'Notify user there was an error');
    assert.equal(this.get('channel.isSubscribed.isSubscribed'), false, 'No subscription happened');
    assert.elementCount(this.$('[data-samus-subscribe-text]'), 1, 'displays subscribe text after failure');
  });
});

test('clicking prime sign up', function(assert) {
  assert.expect(0);

  let channel = {"id": "awesomechannel"};
  this.set('channel', channel);
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/modal
                    channel=channel
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  this.$('.js-samus-trial-text').click();

  //TODO: USE DAVES WINDOW.OPEN UTIL
  /*
    let redirect = function(href) {
    assert.equal(href, `/products/thankyou/${offerUrl}`, 'redirects to the claim url');
    return window;
  };
  this.set('redirect', redirect);

  */
  //assert.equal();

  // TODO how to test window.open?
});
