import { test } from 'ember-qunit';
import EmberObject from 'ember-object';
import wait from 'ember-test-helpers/wait';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('subscribe-button/resub-modal', 'Integration | Component | subscribe-button/resub-modal', {
  beforeEach() {
    this.notify = this.owner.lookup('service:notify');
  }
});

test('Can subscribe with prime credit', function(assert) {
  let channel = EmberObject.extend({
    id: '1',
    isSubscribed: {
      isSubscribed: false
    }
  });

  this.set('isSubscribing', false);
  this.set('setIsSubscribing', (value = false) => {
    this.set('isSubscribing', value);
  });

  this.set('toggle', () => {});
  this.set('toggleHasSubscribedMessage', () => {});
  this.set('channel', channel.create());
  this.set('creditBalance', {hasSubCredit: 1});
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/resub-modal
                    hasPrime=true
                    creditBalance=creditBalance
                    channel=channel
                    isSubscribing=isSubscribing
                    setIsSubscribing=(action setIsSubscribing)
                    toggle=toggle
                    toggleHasSubscribedMessage=toggleHasSubscribedMessage
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  this.$('[data-samus-subscribe-text]').click();

  assert.expect(2);
  return wait().then(() => {
    assert.equal(this.get('channel.isSubscribed.isSubscribed'), true, 'Subscription was successful');
    assert.elementText(this.$('.js-samus-no-credit-text'), 'Not yet!');
  });
});

test('display error message when subscribing returns a server error', function(assert) {
  assert.expect(5);
  let channel = EmberObject.extend({
    id: '1',
    isSubscribed: {
      isSubscribed: false
    }
  });

  this.server.post('https://api.twitch.tv/api/premium/credit/spend', function() {
    assert.ok(true, 'an error is expected');
  }, 500);

  this.set('setIsSubscribing', () => {});
  this.set('channel', channel.create());
  this.set('creditBalance', { hasSubCredit: true });
  this.set('trackSubscribeButtonAction', () => {});
  this.render(hbs`{{subscribe-button/resub-modal
                    hasPrime=true
                    creditBalance=creditBalance
                    channel=channel
                    setIsSubscribing=(action setIsSubscribing)
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);

  assert.equal(this.notify._invocations.length, 0, 'there are no errors');

  this.$('[data-samus-subscribe-text]').click();

  return wait().then(() => {
    assert.equal(this.notify._invocations.length, 1, 'Notify user there was an error');
    assert.equal(this.get('channel.isSubscribed.isSubscribed'), false, 'No subscription happened');
    assert.elementCount(this.$('[data-samus-subscribe-text]'), 1, 'displays subscribe text after failure');
  });
});
