import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import wait from 'ember-test-helpers/wait';

function setupButtonState(self) {
  self.register('service:session', Service.extend({
    userData: {
      chat_oauth_token: 1
    }
  }));
  self.set('hasSubCredit', false);
  self.set('channel', {
    displayName: 'testChannelName'
  });
  self.set('trackSubscribeButtonAction', () => {});
  self.render(hbs`{{subscribe-button/resub
                    channel=channel
                    trackSubscribeButtonAction=trackSubscribeButtonAction}}`);
}

moduleForComponent('subscribe-button/resub', 'Integration | Component | subscribe-button/resub');

test('it renders dynamic subscribe button', function(assert) {
  setupButtonState(this);
  assert.elementCount(this.$('.js-resubscribe-button'), 1);
});

test('displays subscription modal when clicked', function(assert) {
  setupButtonState(this);
  this.$('.js-resubscribe-button').click();

  assert.expect(1);
  return wait().then(() => {
    assert.elementCount($('.js-resubscribe-modal'), 1);
  });
});

test('closes subscription modal when clicking outside the modal', function(assert) {
  setupButtonState(this, {});
  this.$('.js-resubscribe-button').click();

  return wait().then(() => {
    assert.elementCount($('.js-resubscribe-modal'), 1);
    return wait();
  }).then(() => {
    $('body').click();
    return wait();
  }).then(() => {
    assert.elementCount($('.js-resubscribe-modal'), 0);
  });
});
