import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('subscribe-button/subscribed-message', 'Integration | Component | subscribe-button/message');

test('it displays the message when it hasMessage is true', function(assert) {
  this.set('hasMessage', true);
  this.render(hbs`{{subscribe-button/subscribed-message hasMessage=hasMessage}}`);

  assert.elementCount(this.$('[data-test-subscribed-message]'), 1, 'Renders `Refresh to fully activate your subscription`');
});

test('no message when when hasMessage is false', function(assert) {
  this.set('hasMessage', false);
  this.render(hbs`{{subscribe-button/subscribed-message hasMessage=hasMessage}}`);

  assert.elementCount(this.$('[data-test-subscribed-message]'), 0, 'no message rendered');
});
