import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

let channelModel = {
    id: 'fakeChannel',
    partner: true,
    isSubscribed: {
        isSubscribed: false
    },
    viewer: {
        has_ad_free_subscription: false
    }
};

let fakeViewer = {
    userData: {
        login: 'fakeViewer',
        has_turbo: true
    },
    isAuthenticated: true
};

moduleForComponent('support-button', 'Integration | Component | support button', {
    beforeEach() {
        this.defaultTemplate = hbs`
            {{support-button
                channel=channelModel
            }}
        `;
    }
});

test('ad whitelist correctly stored in local storage and toggles', function(assert) {
    assert.expect(2);

    let mockStorageSvc = Service.extend({
      keys: {},

      unknownProperty(key) {
        return this.get(`keys.${key}`);
      },

      setUnknownProperty(key, value) {
        return this.set(`keys.${key}`, value);
      }
    });

    this.set('channelModel', channelModel);
    this.register('service:session', Service.extend(fakeViewer));
    this.register('service:storage', mockStorageSvc);
    this.render(this.defaultTemplate);

    let adWhitelist = this.owner.lookup('service:storage');
    this.$('[data-test-selector=support-button]').click();
    assert.equal(adWhitelist.get('ad-whitelist-fakeChannel'), 'true');
    this.$('[data-test-selector=support-button]').click();
    assert.equal(adWhitelist.get('ad-whitelist-fakeChannel'), 'false');
});

test(`can support if channel is partnered, and user is turbo`, function(assert) {
    assert.expect(1);

    this.set('channelModel', channelModel);
    this.register('service:session', Service.extend(fakeViewer));
    this.render(this.defaultTemplate);

    assert.equal(this.$('[data-test-selector=support-button]').length, 1, 'should show support button');
});

test(`can support if channel is partnered, and user is not turbo and has ad free subscription `, function(assert) {
    assert.expect(1);

    fakeViewer.userData.has_turbo = false;
    channelModel.isSubscribed.isSubscribed = true;
    channelModel.viewer.has_ad_free_subscription = true;
    this.set('channelModel', channelModel);
    this.register('service:session', Service.extend(fakeViewer));
    this.render(this.defaultTemplate);

    assert.equal(this.$('[data-test-selector=support-button]').length, 1, 'should show support button');
});


test(`cannot support if channel is not partnered`, function(assert) {
    assert.expect(1);

    channelModel.partner = false;
    this.set('channelModel', channelModel);
    this.register('service:session', Service.extend(fakeViewer));
    this.render(this.defaultTemplate);

    assert.equal(this.$('[data-test-selector=support-button]').length, 0, 'do not show support button');
});
