import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('svg-icon', 'Integration | Component | svg icon', {
  integration: true,

  beforeEach() {
    this.owner.register('template:path/to/dummy-template', hbs`partial-content`);
  }
});

test('it renders with the correct tag, classes, and template partial', function (assert) {
  assert.expect(4);

  this.set('path', 'path/to/dummy-template');

  this.render(hbs`
    {{svg-icon iconModifier=iconModifier path=path}}
  `);

  assert.ok(this.$('figure').hasClass('icon'), '`.icon` class is set to the component (<figure>) by default');
  assert.notOk(this.$('figure').hasClass('test-icon-modifier-class'), 'no passed-in class present');
  assert.equal(this.$().text().trim(), 'partial-content', 'passed-in template path is rendered');

  this.set('iconModifier', 'test-icon-modifier-class');

  assert.ok(this.$('figure').hasClass('test-icon-modifier-class'), 'passed-in iconModifier class is set');
});
