import EmberObject from 'ember-object';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import Ember from 'ember';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { A as emberA } from 'ember-array/utils';

const { Component } = Ember;

moduleForComponent('tag-streams', {
  beforeEach() {
    this.owner.register('component:infinite-scroll', Component.extend({}));
    this.owner.register('template:component/infinite-scroll', hbs`{{yield}}`);
  }
});

test('displays channel tab when CHANNELS is provided', function (assert) {
  assert.expect(1);
  this.set('game', EmberObject.create({ name: 'Creative' }));
  this.set('streamList', 'CHANNELS');
  this.set('model', emberA([
    {id: 1, preview: "previewURL"},
    {id: 2, preview: "previewURL"},
    {id: 3, preview: "previewURL"}
  ]));
  this.render(hbs`{{tag-streams game=game streamList=streamList model=model}}`);
  assert.equal(this.$('.js-streams').length, 1, 'live channels tab is active');
});

test('displays videos tab when VODS is provided', function (assert) {
  assert.expect(1);
  this.set('game', { name: 'Creative' });
  this.set('streamList', 'VODS');
  this.set('model', emberA([
    {id: 1, preview: "previewURL"},
    {id: 2, preview: "previewURL"},
    {id: 3, preview: "previewURL"}
  ]));
  this.render(hbs`{{tag-streams game=game streamList=streamList model=model}}`);
  assert.equal(this.$('.js-videos').length, 1, 'vods tab is active');
});
