import EmberObject from 'ember-object';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const TITLE_SELECTOR = '.ct-header__main';
const TAG_SELECTOR = '.ct-header__sub';

moduleForComponent('tag-title');

const foodTag = EmberObject.create({ name: 'food' });

test('it displays no tag by default', function (assert) {
  assert.expect(1);
  this.set('title', 'Creative');
  this.render(hbs`{{tag-title title=title}}`);
  assert.equal(this.$(TITLE_SELECTOR).text().trim(), this.get('title'));
});

test('it displays a tag when provided', function (assert) {
  assert.expect(1);
  this.set('title', 'Creative');
  this.set('currentTag', foodTag);
  this.render(hbs`{{tag-title title=title currentTag=currentTag}}`);
  assert.equal(this.$(TAG_SELECTOR).text().trim(), `#${this.get('currentTag').get('name')}`);
});
