import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('Unit | Integration | time-picker', {
  beforeEach() {
    this.onChangeValues = [];
    this.set('onChange', (value) => {
      this.onChangeValues.push(value);
    });
  }
});

test('picking a time', function(assert) {
  this.render(hbs`{{time-picker onChange=onChange}}`);

  this.$('input').click();

  assert.ok(this.$('ul').is(':visible'), 'list is visible after clicking in the input');

  this.$('li:contains(11:30pm)').click();

  assert.ok(this.$('ul').is(':hidden'), 'list is hidden after selecting a time');

  this.$('input').click();

  assert.ok(this.$('ul').is(':visible'), 'list visible again when clicking');

  assert.deepEqual(this.onChangeValues, ['11:30pm']);
});

test('manually entering a time', function(assert) {
  this.render(hbs`{{time-picker onChange=onChange}}`);

  this.$('input').click();
  assert.ok(this.$('ul').is(':visible'), 'list is visble after clicking in the input');

  this.$('input').val('1:30am');
  this.$('input').trigger('input');
  assert.ok(this.$('ul').is(':hidden'), 'list is hidden once typing starts');

  this.$('input').change();

  assert.deepEqual(this.onChangeValues, ['1:30am']);
});

test('parsing a time', function(assert) {
  this.render(hbs`{{time-picker onChange=onChange}}`);

  let times = [{
    input:  '1am',
    output: '1:00am'
  }, {
    input:  '4:15',
    output: '4:15am'
  }, {
    input:  '20',
    output: '8:00pm'
  }, {
    input:  '1p',
    output: '1:00pm'
  }, {
    input:  'xyz',
    output: ''
  }];

  times.forEach(({ input }) => {
    this.$('input').val(input);
    this.$('input').change();
  });

  assert.deepEqual(this.onChangeValues, times.map(t => t.output));
});

test('setting the default value', function(assert) {
  this.set('date', new Date(2016, 10, 30, 14, 32));
  this.render(hbs`{{time-picker time=date}}`);

  assert.equal(this.$('input').val(), '2:32pm', 'parses and shows time');
});

test('setting an invalid default value', function(assert) {
  this.set('time', Infinity);
  this.render(hbs`{{time-picker time=time}}`);

  assert.equal(this.$('input').val(), '', 'shows a blank time');
});

test('setting a default value that is in the list of times', function(assert) {
  this.set('date', new Date(2016, 10, 30, 14, 30));
  this.render(hbs`{{time-picker time=date}}`);

  assert.equal(this.$('.balloon__link--active').text().trim(), '2:30pm', 'The default time appears selected');

  this.$('input').click();
  assert.ok(this.$('ul').scrollTop() > 0, 'scroll container has been scrolled');
});
