import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

const CAROUSEL_ITEM_SELECTOR = '.card-carousel__item';
const NEXT_BUTTON_SELECTOR = '[data-test-selector=twitch-carousel-next-button]';
const PREV_BUTTON_SELECTOR = '[data-test-selector=twitch-carousel-prev-button]';

moduleForComponent('twitch-carousel/card-carousel', 'Integration | Components | twitch-carousel/card-carousel', {
  integration: true,

  beforeEach() {
    let fakeStream = {
      id: 'foo-bar',
      preview: {
        medium: '//blah.com/foo.jpg'
      },
      channel: {
        name: 'foo-bar',
        display_name: 'foo-bar'
      },
      viewers: 100
    };

    this.set('fakeRecommendedStream', {
      streams: [fakeStream, fakeStream, fakeStream]
    });
  }
});

test('renders', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{twitch-carousel/card-carousel
      items=fakeRecommendedStream.streams
      itemComponent='stream/snapshot-card'}}`);

  return wait().then(() => {
    assert.equal(this.$(CAROUSEL_ITEM_SELECTOR).length, 3, 'correct number of streams');
  });
});

test('shows no arrows if no additional streams', function (assert) {
  assert.expect(3);

  this.render(hbs`
    {{twitch-carousel/card-carousel
      items=fakeRecommendedStream.streams
      itemComponent='stream/snapshot-card' streamsPerRow=3}}`);

  return wait().then(() => {
    assert.equal(this.$(CAROUSEL_ITEM_SELECTOR).length, 3, 'correct number of streams');
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).is(':hidden'), true, 'next button is hidden');
    assert.equal(this.$(PREV_BUTTON_SELECTOR).is(':hidden'), true, 'prev button is hidden');
  });
});

test('after clicking next for one more page', function (assert) {
  assert.expect(5);

  this.render(hbs`
    {{twitch-carousel/card-carousel
      items=fakeRecommendedStream.streams
      itemComponent='stream/snapshot-card' streamsPerRow=2}}`);

  return wait().then(() => {
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).length, 1, 'next button is present');
    this.$(NEXT_BUTTON_SELECTOR)[0].click();
    return wait();
  }).then(() => {
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).length, 1, 'next button is present');
    assert.equal(this.$(PREV_BUTTON_SELECTOR).length, 1, 'prev button is present');
    assert.equal(this.$(PREV_BUTTON_SELECTOR)[0].disabled, false, 'prev button is enabled');
    assert.equal(this.$(NEXT_BUTTON_SELECTOR)[0].disabled, true, 'next button is disabled');
  });
});

test('after clicking next then previous', function (assert) {
  assert.expect(8);

  this.render(hbs`
    {{twitch-carousel/card-carousel
      items=fakeRecommendedStream.streams
      itemComponent='stream/snapshot-card' streamsPerRow=1}}`);

  return wait().then(() => {
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).length, 1, 'next button is present');
    this.$(NEXT_BUTTON_SELECTOR)[0].click();
    return wait();
  }).then(() => {
    assert.equal(this.$(PREV_BUTTON_SELECTOR).length, 1, 'prev button is present');
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).length, 1, 'next button is present');
    assert.equal(this.$(NEXT_BUTTON_SELECTOR)[0].disabled, false, 'next button is enabled');
    this.$(PREV_BUTTON_SELECTOR)[0].click();
    return wait();
  }).then(() => {
    assert.equal(this.$(NEXT_BUTTON_SELECTOR).length, 1, 'next button is present');
    assert.equal(this.$(PREV_BUTTON_SELECTOR).length, 1, 'prev button is present');
    assert.equal(this.$(PREV_BUTTON_SELECTOR)[0].disabled, true, 'prev button is disabled');
    assert.equal(this.$(NEXT_BUTTON_SELECTOR)[0].disabled, false, 'next button is enabled');
  });
});
