import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import Ember from 'ember';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

const { helper } = Ember.Helper;

moduleForComponent('twitch-prime/benefits-list', 'Integration | Component | twitch-prime/benefits-list', {
  integration: true,
  
  beforeEach() {
    this.routeActionInvocations = [];
    this.owner.register('helper:route-action', helper(([...args]) => {
      return (...invocationArgs) => {
        this.routeActionInvocations.push(args.concat(invocationArgs));
      };
    }));
  }
});

test('in game content', function(assert) {
  assert.expect(3);

  this.render(hbs`{{twitch-prime/benefits-list goToRedirectRouteWithOffers=(route-action 'goToRedirectRouteWithOffers')}}`);

  let $header = this.$().find('[data-test-benefits-welcome-header]');
  let $button = this.$().find('[data-test-benefits-welcome-button]');

  assert.elementText($header, 'Claim your free loot', 'Header text is correct');
  assert.elementText($button, 'See loot', 'Button text is correct');

  $button.click();

  return wait().then(() => {
    let routeActionInvocation = this.routeActionInvocations[0];
    assert.equal(routeActionInvocation[0], 'goToRedirectRouteWithOffers', 'Route action was invoked');
  });
});

test('prime sub', function(assert) {
  assert.expect(4);

  this.render(hbs`{{twitch-prime/benefits-list goToRedirectRouteWithSubModal=(route-action 'goToRedirectRouteWithSubModal')}}`);

  let $header = this.$().find('.pr-welcome__content--live-screen .pr-welcome__header');
  let $desc = this.$().find('.pr-welcome__content--live-screen .pr-welcome__description');
  let $button = this.$().find('.pr-welcome__cta--live-screen');

  assert.elementText($header, 'Use your free channel subscription', 'Header text is correct');
  assert.elementText($desc, "Directly supports your favorite streamer, and you can subscribe again for free every 30 days.", 'Description is correct');
  assert.elementText($button, 'Subscribe Free', 'Button text is correct');

  $button.click();

  return wait().then(() => {
    let routeActionInvocation = this.routeActionInvocations[0];
    assert.equal(routeActionInvocation[0], 'goToRedirectRouteWithSubModal', 'Route action was invoked');
  });
});
