import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('twitch-prime/offer-item', 'Integration | Component | twitch-prime/offer-item');

test('offer-item can display the tooltip', function(assert) {
  assert.expect(1);
  let offersCount = 1;
  this.server.createList('offer', offersCount);

  this.render(hbs`
    {{#twitch-prime/offer-item offer=offer showTooltip=true as |showTooltip tetherId|}}
      {{#if showTooltip}}
        {{twitch-prime/offer-detail
          offer=offer
          tetherId=tetherId}}
      {{/if}}
    {{/twitch-prime/offer-item }}
  `);

  assert.elementCount($('.offer-item__balloon'), 1);
});
