import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { SHOW_FEWER_STR, SHOW_ALL_STR } from 'web-client/components/twitch-two-row';

const STREAMS_SELECTOR = '[data-test-selector=twitch-two-row-stream]';
const TOGGLE_BUTTON_SELECTOR = '[data-test-selector=twitch-two-row-toggle-button]';
const TOGGLE_TEXT_SELECTOR = '[data-test-selector=twitch-two-row-toggle-text]';

moduleForComponent('twitch-two-row', {
  beforeEach() {
    let fakeStream = {
      preview: {
        medium: '//blah.com/foo.jpg'
      },
      channel: {
        name: 'foo-bar',
        displayName: 'foo-bar'
      },
      viewers: 100
    };

    this.set('fakeRecommendedStream', {
      channel: 'foobar',
      streams: [fakeStream, fakeStream, fakeStream]
    });
  }
});

test('renders correct number of streams', function (assert) {
  assert.expect(1);

  this.render(hbs`{{twitch-two-row recommendedStream=fakeRecommendedStream streamsPerRow=3}}`);

  return wait().then(() => {
    assert.equal(this.$(STREAMS_SELECTOR).length, 3);
  });
});

test('renders correct number of streams when truncated', function (assert) {
  assert.expect(1);

  this.render(hbs`{{twitch-two-row recommendedStream=fakeRecommendedStream streamsPerRow=1}}`);

  return wait().then(() => {
    assert.equal(this.$(STREAMS_SELECTOR).length, 1);
  });
});

test('shows view all button if there are many', function (assert) {
  assert.expect(2);

  this.render(hbs`{{twitch-two-row recommendedStream=fakeRecommendedStream streamsPerRow=1}}`);

  return wait().then(() => {
    assert.equal(this.$(TOGGLE_BUTTON_SELECTOR).length, 1);
    assert.equal(this.$(TOGGLE_TEXT_SELECTOR).text().trim(), SHOW_ALL_STR);
  });
});

test('does not show view all button if there are no more streams to show', function (assert) {
  assert.expect(1);

  this.render(hbs`{{twitch-two-row recommendedStream=fakeRecommendedStream streamsPerRow=3}}`);

  return wait().then(() => {
    assert.equal(this.$(TOGGLE_BUTTON_SELECTOR).length, 0);
  });
});

test('viewAll text changes when clicked', function (assert) {
  assert.expect(3);

  this.render(hbs`{{twitch-two-row recommendedStream=fakeRecommendedStream streamsPerRow=1}}`);

  return wait().then(() => {
    assert.equal(this.$(TOGGLE_BUTTON_SELECTOR).length, 1);
    assert.equal(this.$(TOGGLE_TEXT_SELECTOR).text().trim(), SHOW_ALL_STR);
    this.$(TOGGLE_BUTTON_SELECTOR).click();
    return wait();
  }).then(() => {
    assert.equal(this.$(TOGGLE_TEXT_SELECTOR).text().trim(), SHOW_FEWER_STR);
  });
});
