import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';

moduleForComponent('upsell-follow-button', 'Integration | Component | upsell-follow-button', {
});

test('upsell-follow-button renders with additional classes', function(assert) {
  this.render(hbs`{{upsell-follow-button btnClasses='js-channel-upsell-btn'}}`);
  assert.elementCount('button.js-channel-upsell-btn', 1);
});

test('upsell-follow-button renders with provided text', function(assert) {
  this.render(hbs`{{upsell-follow-button btnClasses='js-channel-upsell-btn' text='Oh hey, you should do stuff'}}`);
  assert.elementText('button.js-channel-upsell-btn', 'Oh hey, you should do stuff');
});

test('upsell-follow-button click shows the auth overlay to log in by default', function(assert) {
  sinon.spy($, 'showAuthenticationOverlay');
  this.render(hbs`{{upsell-follow-button btnClasses='js-channel-upsell-btn'}}`);
  this.$('button.js-channel-upsell-btn').click();
  assert.ok($.showAuthenticationOverlay.calledWith('login'));
  $.showAuthenticationOverlay.restore();
});

test('upsell-follow-button click calls the auth overlay to sign up if type is `signup`', function(assert) {
  sinon.spy($, 'showAuthenticationOverlay');
  this.render(hbs`{{upsell-follow-button btnClasses='js-channel-upsell-btn' type='signup'}}`);
  this.$('button.js-channel-upsell-btn').click();
  assert.ok($.showAuthenticationOverlay.calledWith('signup'));
  $.showAuthenticationOverlay.restore();
});
