import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Ember from 'ember';
const { Object: EmberObject } = Ember;

moduleForComponent('user-error', {
  beforeEach() {
    this.set('model', EmberObject.create({
      notFound: false,
      nonGaming: false,
      unavailable: false
    }));

    this.render(hbs`{{user-error model=model}}`);
  }
});

test('it renders', function(assert) {
  assert.equal(this.$().text().trim(), 'Browse Other Channels');
});

test('not found', function(assert) {
  this.set('model.notFound', true);

  assert.stringIncludes(this.$().text().trim(), 'that content is unavailable', 'shows not found message');
});

test('non-gaming', function(assert) {
  this.set('model.nonGaming', true);

  assert.stringIncludes(this.$().text().trim(), 'This is a Justin.tv channel. It cannot be viewed on Twitch.', 'shows non-gaming message');
});

test('not found', function(assert) {
  this.set('model.unavailable', true);

  assert.stringIncludes(this.$().text().trim(), 'The community has closed this channel', 'unavailable message');
});
