import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import { configure } from 'web-client/utilities/vod-appeals-util';
import hbs from 'htmlbars-inline-precompile';
import videoAppealScenario from 'web-client/mirage/scenarios/video-appeal';
import VideoAppealsForm from 'web-client/components/video/appeals/input-form/component';
import wait from 'ember-test-helpers/wait';
import EmberObject from 'ember-object';

const notify = {error: function (){}};

moduleForComponent('video/appeals/input-form', 'Integration | Component | video/appeals/input-form', {
  beforeEach() {
    configure({
      notify: notify // TODO drop this
    });
  }
});

test('it renders', function (assert) {
  assert.expect(1);

  let vodId = 'my-vod-id';
  videoAppealScenario(this.server, vodId);
  this.set('vodId', vodId);
  this.render(hbs`{{video/appeals/input-form vodId=vodId}}`);

  return wait()
    .then(() => {
      assert.stringIncludes(this.$().text(), 'Appeal Muted Audio', 'template renders');
    });
});

test('it requires vodId', function (assert) {
  assert.throws(() => {
    this.render(hbs`{{video/appeals/input-form}}`);
  }, /requires a vodId/);
});

test('tracksToAppeal computed property', function (assert) {
  assert.expect(1);

  // get a handle on the object
  let vodId = 'my-vod-id';
  let componentInstance;

  videoAppealScenario(this.server, vodId);
  this.set('vodId', vodId);
  this.owner.register('component:video/appeals/input-form', VideoAppealsForm.extend({
    init: function () {
      this._super(...arguments);
      componentInstance = this;
    }
  }));

  this.render(hbs`{{video/appeals/input-form vodId=vodId}}`);

  let expected = [
    {'audible_magic_response_id': 111, 'reason': 'reason1'},
    {'audible_magic_response_id': 222, 'reason': 'reason2'}
  ];

  return wait().then(() => {
    componentInstance.set('mutedTracks', [
      EmberObject.create({ id: 111, reasonForAppealing: EmberObject.create({ reason: 'reason1' }) }),
      EmberObject.create({ id: 222, reasonForAppealing: EmberObject.create({ reason: 'reason2' }) })
    ]);
    assert.deepEqual(componentInstance.get('tracksToAppeal'), expected);
  });
});
