import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import EmberObject from 'ember-object';

export const PREVIEW_CARD = '.card';
export const DISMISSED_CARD = '[data-test-selector=dismissed-card]';
export const GEAR_BUTTON = '[data-test-selector=gear-button]';
export const GEAR_MENU = '[data-test-selector=gear-menu]';
export const REMOVE_VIDEO = '[data-test-selector=remove-video]';
export const TELL_US_WHY = '[data-test-selector=tell-us-why]';
export const UNDO_DISMISS = '[data-test-selector=undo-dismiss]';
export const DISMISS_MODAL = '[data-test-selector=coviews-dismiss-modal]';

let fakeRouter = EmberObject.extend({
    send() {}
});

moduleForComponent('video/coviews/carousel-card', 'Integration | Component | video/coviews/carousel-card', {
    beforeEach() {
        let fakeVideo = {
            preview: {
                medium: '//blah.com/foo.jpg'
            },
            id: 123,
            channel: {
                name: 'charishaxd'
            }
        };
        this.set('fakeVideo', fakeVideo);
        this.owner.lookup('service:vod-coviews').set('vods', [fakeVideo]);
        this.owner.lookup('service:vod-coviews').set('recommendedVods', [fakeVideo]);

        this.owner.register('router:main', fakeRouter);
    }
});


test('renders', function (assert) {
  assert.expect(2);

  this.render(hbs`{{video/coviews/carousel-card video=fakeVideo tt_medium="medium" tt_content="content"}}`);

  return wait().then(() => {
    assert.equal(this.$(PREVIEW_CARD).length, 1, 'shows preview card');
    assert.equal(this.$(DISMISSED_CARD).length, 0, 'does not show dismissed card');
  });
});

test('gear icon shows and hides when mouse enters', function(assert) {
  assert.expect(3);

  this.render(hbs`{{video/coviews/carousel-card video=fakeVideo tt_medium="medium" tt_content="content"}}`);

  return wait().then(() => {
    assert.equal(this.$(GEAR_BUTTON).hasClass('hide'), true, 'gear button hidden initially');
    this.$(PREVIEW_CARD).mouseenter();
    return wait();
  }).then(() => {
    assert.equal(this.$(GEAR_BUTTON).hasClass('show'), true, 'gear button showing');
    this.$(PREVIEW_CARD).mouseleave();
    return wait();
  }).then(() => {
    assert.equal(this.$(GEAR_BUTTON).hasClass('hide'), true, 'gear button hidden');
  });
});

test('remove video replaces video preview card', function(assert) {
  assert.expect(4);

  this.render(hbs`{{video/coviews/carousel-card video=fakeVideo tt_medium="medium" tt_content="content"}}`);

  return wait().then(() => {
    this.$(PREVIEW_CARD).trigger('mouseenter');
    this.$(GEAR_BUTTON).click();
    return wait();
  }).then(() => {
    assert.equal(this.$(GEAR_MENU).hasClass('show'), true, 'menu shows');
    assert.equal(this.$(REMOVE_VIDEO).length, 1, 'remove video is an option');
    this.$(REMOVE_VIDEO).click();
    return wait();
  }).then(() => {
    assert.equal(this.$(TELL_US_WHY).length, 1, `"tell us why" is visible`);
    assert.equal(this.$(UNDO_DISMISS).length, 1, `"undo" is visible`);
  });
});
