import moment from 'moment';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';
import { test } from 'ember-qunit';
import { assign } from 'ember-platform';
import hbs from 'htmlbars-inline-precompile';
import EmberObject from 'ember-object';

function getDirectText(context, selector) {
  return context.$(selector).clone().children().remove().end().text().trim();
}

function setupVideo(context, options = {}) {
  context.set('vodModel', EmberObject.create(assign(options, {
    recordedDate: moment([2016, 10, 6]).toISOString(),
    broadcast_type: ARCHIVE_TYPE_PARAM,
    views: 123
  })));
}

moduleForComponent('video/metadata-box', {
  beforeEach() {
    this.set('channel', {
      views: 456
    });
  }
});

test('renders metadata box for video', function(assert) {
  setupVideo(this);
  assert.expect(7);
  this.render(hbs`{{video/metadata-box vodModel=vodModel}}`);

  assert.equal(getDirectText(this, '.js-cn-metabar .js-card__title'), '', 'empty title renders');
  assert.elementText('.js-cn-metabar .js-card__info', '', 'empty game info renders');
  assert.elementCount('.js-cn-metabar .js-cn-metabar__timeago', 1, 'time ago renders');
  assert.elementCount('.js-cn-metabar .js-cn-metabar__viewcount div:contains(123)', 1, 'total views renders');
  assert.elementCount('.js-cn-metabar .js-share-box', 1, 'share box renders');
  assert.elementCount('.js-cn-metabar .js-channel-options', 1, 'channel options renders');
  assert.elementCount('.js-cn-metabar .js-cn-edit-link', 0, 'does not render edit button');
});

test('renders edit button if `isEditable` is set', function(assert) {
  setupVideo(this);
  assert.expect(1);
  this.render(hbs`{{video/metadata-box channel=channel vodModel=vodModel isEditable=true}}`);

  assert.elementCount('.js-cn-metabar .js-cn-edit-link', 1, 'renders edit button');
});

test('renders title if status is set for video', function(assert) {
  assert.expect(1);
  setupVideo(this, {
    title: 'Oh Canada!'
  });

  this.render(hbs`{{video/metadata-box channel=channel vodModel=vodModel}}`);
  assert.equal(getDirectText(this, '.js-cn-metabar .js-card__title'), 'Oh Canada!', 'renders title');
});

test('renders game info', function(assert) {
  assert.expect(3);
  setupVideo(this, {
    game: 'Counter Strike',
    gameBoxArt: '//bloop-bloop.tv/box-art.png'
  });

  this.render(hbs`{{video/metadata-box channel=channel vodModel=vodModel}}`);

  assert.elementCount('.js-cn-metabar a:has(img[src="//bloop-bloop.tv/box-art.png"])', 1, 'renders box art with link');
  assert.elementCount('.js-cn-metabar .js-card__info a:contains(Counter Strike)', 1, 'renders game link');
  assert.elementText('.js-cn-metabar .js-card__info', 'Counter Strike', 'renders no additional copy, just the link');
});

test('when video is rendered on metadata-box', function(assert) {
  setupVideo(this);
  this.render(hbs`{{video/metadata-box vodModel=vodModel}}`);

  let recordedDate = moment(this.get('vodModel.recordedDate')).fromNow();
  let result = `• ${recordedDate}`;
  assert.equal(getDirectText(this, 'span'), result, 'should always display a relative time');
});
