import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';

moduleForComponent('video/more-info-box');

test('displayedBroadcastType is "Past Broadcast" for "archive" type', function(assert) {
  this.set('description', 'Wow, this video is awesome!');
  this.set('broadcastType', ARCHIVE_TYPE_PARAM);

  this.render(hbs`{{video/more-info-box description='' isExpanded=true broadcastType=broadcastType}}`);
  assert.ok(this.$('h5:contains(Video Category: Past Broadcast)').length);
});

test('displayedBroadcastType is capitalized if not "archive" type', function(assert) {
  this.set('description', 'Wow, this video is awesome!');
  this.set('broadcastType', 'coolvideo');

  this.render(hbs`{{video/more-info-box description='' isExpanded=true broadcastType=broadcastType}}`);
  assert.ok(this.$('h5:contains(Video Category: Coolvideo)').length);
});

test('clicking Show More expands the box', function(assert) {
  this.set('description', 'Wow, this video is awesome!');
  this.set('broadcastType', ARCHIVE_TYPE_PARAM);

  this.render(hbs`{{video/more-info-box description=description broadcastType=broadcastType}}`);

  assert.equal(this.$('h5:contains(Video Category: Past Broadcast)').length, 0);
  this.$('.cn-vod-info__toggle button').click();
  assert.equal(this.$('h5:contains(Video Category: Past Broadcast)').length, 1);
});
