import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';

moduleForComponent('video/rechat/display-container', 'Integration | Component | video/rechat/display-container', {
  beforeEach() {
    this.set('video', {});

    this.register('service:vod-chat-service', Service.extend({
      setVideo(video) {
        this.video = video;
      },

      clearVideo() {
        this.video = null;
      }
    }));

    this.chatService = this.owner.lookup('service:vod-chat-service');
  }
});

test('setting the video on the vod-chat-service', function(assert) {
  this.set('isShowing', true);

  this.render(hbs`
    {{#if isShowing}}
      {{video/rechat/display-container video=video}}
    {{/if}}
  `);

  assert.strictEqual(this.chatService.video, this.video, 'sets the video on the service when initialized');

  this.set('isShowing', false);

  assert.equal(this.chatService.video, null, 'clears the video when destroyed');

  this.set('isShowing', true);

  assert.strictEqual(this.chatService.video, this.video, 'sets the video when reinitialized');

  this.set('video', { id: 'new-video' });

  assert.strictEqual(this.chatService.video, this.get('video'), 'updates the video when a new video attr is received');
});
