import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import EmberObject from 'ember-object';
import run from 'ember-runloop';

const VIDEO = EmberObject.extend({});

moduleForComponent('video/right-column', 'Integration | Component | video/right-column', {
  beforeEach() {
    this.inject.service('layout');
    this.set('video', VIDEO);
    this.template = hbs`{{video/right-column video=video}}`;
  }
});

test('should show the right column when the layout service turns it on', function(assert) {
  assert.expect(1);

  run(() => {
    this.layout.set('showRightColumn', true);
    this.render(this.template);
    assert.equal(this.$('.closed').length, 0, 'should respect the layout value');
  });
});

test('should hide the right column when the layout service turns it off', function(assert) {
  assert.expect(1);

  run(() => {
    this.layout.set('showRightColumn', false);
    this.render(this.template);
    assert.equal(this.$('.closed').length, 1, 'should respect the layout value');
  });
});
