import { skip } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import { assign } from 'ember-platform';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { generateSearchResult } from 'web-client/mirage/fixtures/video-search-result';

const SEARCH_CARD_SELECTOR = '[data-test-selector="search-card"]';

moduleForComponent('video/search-card-row', 'Integration | Component | video/search-card-row', {
  beforeEach() {
    this.onClickSpy = sinon.spy();

    let videoSearchResult = assign(generateSearchResult(), {
      created_at: 1481758961,
      length: 23,
      broadcaster_login: 'foo',
      broadcaster_name: 'Foo',
      title: 'Title'
    });

    this.set('onClick', this.onClickSpy);
    this.set('video', videoSearchResult);

    this.template = hbs`
      {{video/search-card-row onClick=onClick testSelector='search-card' video=video}}
    `;
    this.render(this.template);
  }
});

skip('renders the card correctly', function (assert) {
  assert.elementCount(SEARCH_CARD_SELECTOR, 1, 'should render the card');
  assert.elementText(SEARCH_CARD_SELECTOR, 'Title Dec 14, 2016 · 0:23 · Foo', 'should render the element text correctly');
});

skip('clicking the search card', function(assert) {
  this.$(SEARCH_CARD_SELECTOR).click();
  assert.ok(this.onClickSpy.called, 'should invoke the provided onClick callback');
});
