import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Component from 'ember-component';

moduleForComponent('yield-element', 'Integration | Component | yield-element', {
  integration: true
});

test('yields an element and attaches it later', function(assert) {
  assert.expect(1);

  this.register('component:early-element-user', Component.extend({
    init() {
      this._super(...arguments);
      this.injectedElement.innerHTML = 'hi';
    }
  }));

  this.render(hbs`
    {{#yield-element as |element id|}}
      {{early-element-user injectedElement=element}}
      <p id={{id}}></p>
    {{/yield-element}}
  `);

  assert.equal(this.$('p').text(), 'hi', 'early-element-user was able to use element in init');
});
