import { module, test } from 'qunit';
import startApp from '../helpers/start-app';
import destroyApp from '../helpers/destroy-app';
import response from '../helpers/fixtures/top-games';

let store, hash;

module('Integration: Deserializing a game', {
  beforeEach() {
    this.application = startApp();
    store = this.application.__container__.lookup('service:store');

    let serializer = store.serializerFor('game');

    hash = serializer.normalizeQueryResponse(store, 'game', response, null);
  },
  afterEach() {
    destroyApp(this.application);
  }
});

test('deserializes all the records', (assert) => {
  assert.ok(hash.data.length === 40, '40 games');
  assert.ok(hash.included.length === 80, '80 sized-images');
});

test('a single record contains all attributes', (assert) => {
  let game = hash.data.findBy('id', 'Counter-Strike: Global Offensive');
  assert.ok(game, 'Counter-Strike is one of the games');

  assert.deepEqual(game.attributes, {
    channelCount: 1222,
    giantbombId: 36113,
    name: 'Counter-Strike: Global Offensive',
    viewerCount: 169744,
    featuredOnSidePanel: false,
    featuredOnDirectory: false,
    trackingUrls: null
  }, 'attributes hash');
});

test('every record contains a box and a logo relationship', (assert) => {
  assert.ok(hash.data.every(game => {
    return game.relationships.box && game.relationships.logo;
  }), 'every record has a box and a logo');
});
