import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('Integration | Helpers | commatized');

test('formatting numbers with commas', function(assert) {
  this.render(hbs`
    <p>{{commatized 1234}}</p>
    <p>{{commatized 1234.12}}</p>
    <p>{{commatized nothing}}</p>
    <p>{{commatized 'string'}}</p>
  `);

  assert.deepEqual(
    this.$('p').toArray().map(p => p.textContent),
    ['1,234', '1,234.12', '0', 'string'],
    'adds commas to numbers'
  );
});
