import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('contains-text', 'helper:contains-text');

test('is true when text is included', function (assert) {
  this.set('title', 'Yo #mature');
  this.render(hbs`[{{if (contains-text title '#mature') 'R' 'G'}}]`);

  assert.equal(this.$().text(), '[R]');
});

test('is false when text is not included', function (assert) {
  this.set('title', 'Hi!');
  this.render(hbs`[{{if (contains-text title '#mature') 'R' 'G'}}]`);

  assert.equal(this.$().text(), '[G]');
});

test('does not throw when test to search in is undefined', function (assert) {
  this.render(hbs`[{{if (contains-text undefined '#mature') 'R' 'G'}}]`);

  assert.equal(this.$().text(), '[G]');
});
