import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('file-size-progress', 'helper:file-size-progress');

test('small kilobytes', function (assert) {
  this.render(hbs`{{file-size-progress 11 11}}`);
  assert.equal(this.$().text(), '0.01 of 0.01KB');
});

test('large kilobytes', function (assert) {
  // Would calculate to 500.00 of 999.25KB
  this.render(hbs`{{file-size-progress 512000 1023232}}`);

  assert.equal(this.$().text(), '500 of 999KB');
});

test('small megabyes', function (assert) {
  // Would calculate to 500.00 of 999.5KB
  this.render(hbs`{{file-size-progress 512000 1023488}}`);

  assert.equal(this.$().text(), '0.49 of 0.98MB');
});

test('medium megabyes', function (assert) {
  // Would calculate to 0 of 85.51MB
  this.render(hbs`{{file-size-progress 1 89684705}}`);

  assert.equal(this.$().text(), '0.00 of 85.5MB');
});

test('large gigabytes', function (assert) {
  // Would calculate to 5.444 of 1001.8GB
  this.render(hbs`{{file-size-progress 5845450490 1075674559283}}`);

  assert.equal(this.$().text(), '5.44 of 1002GB');
});

test('zero for partial works', function (assert) {
  this.render(hbs`{{file-size-progress 0 11}}`);
  assert.equal(this.$().text(), '0.00 of 0.01KB');
});

test('returns an empty string when passed undefined values', function (assert) {
  this.render(hbs`{{file-size-progress nothing nothing}}`);
  assert.equal(this.$().text(), '');
});

test('can override the separator', function (assert) {
  this.render(hbs`{{file-size-progress 0 11 separator='override'}}`);
  assert.equal(this.$().text(), '0.00 override 0.01KB');
});
