import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('format-date', 'helper:format-date');

test('handling unix timestamps', function (assert) {
  this.render(hbs`{{format-date 1467829674 'YYYY-MM-DD'}}`);
  assert.equal(this.$().text(), '2016-07-06');
});

test('handling dates', function (assert) {
  this.set('date', new Date(2016, 6, 6));
  this.render(hbs`{{format-date date 'YYYY-MM-DD'}}`);
  assert.equal(this.$().text(), '2016-07-06');
});

test('handling parsable string', function (assert) {
  this.render(hbs`{{format-date '2016-07-06' 'YYYY-MM-DD'}}`);
  assert.equal(this.$().text(), '2016-07-06');
});
