import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('format-display-name', 'helper:format-display-name');

test('Given an ASCII displayName', function (assert) {
  this.render(hbs`{{format-display-name 'mitch' ' Mitch '}}`);
  assert.equal(this.$().text(), ' Mitch ', 'return the displayName');
});

test('Given a non-ASCII displayName', function (assert) {
  this.render(hbs`{{format-display-name 'mitch' '漢字123'}}`);
  assert.equal(this.$().text(), `漢字123 (mitch)`, 'returns a formatted name');
});

test('Given a non-ASCII displayName (the character is from the extended ASCII set)', function (assert) {
  this.render(hbs`{{format-display-name 'hari' 'häri'}}`);
  assert.equal(this.$().text(), `häri (hari)`, 'returns a formatted name');
});

test('Given no displayName', function (assert) {
  this.render(hbs`{{format-display-name 'hari' null}}`);
  assert.equal(this.$().text(), 'hari', 'return the login');
});

test('Given no login', function (assert) {
  this.render(hbs`{{format-display-name null 'hari'}}`);
  assert.equal(this.$().text(), 'hari', 'return the displayName');
});

test('Given no login and no displayName', function (assert) {
  this.render(hbs`{{format-display-name null null}}`);
  assert.equal(this.$().text(), '', 'return the login');
});

test('Given non-ASCII displayName and login and displayName contain HTML', function (assert) {
  this.render(hbs`{{format-display-name 'hari</span>' '<span>häri'}}`);
  assert.equal(this.$().text(), '<span>häri (hari</span>)', 'return the formatted displayName with login and displayname with HTML escaped');
});
