import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('Integration | Helpers | format-number');

test('formatting numbers', function(assert) {
  this.render(hbs`
    <p>{{format-number 1234}}</p>
    <p>{{format-number 1234.12}}</p>
    <p>{{format-number 1234 scale=2}}</p>
    <p>{{format-number 1234.123 scale=2}}</p>
    <p>{{format-number 1234 separator=' '}}</p>
  `);

  assert.deepEqual(
    this.$('p').toArray().map(p => p.textContent),
    ['1,234', '1,234.12', '1,234.00', '1,234.12', '1 234'],
    'formats numbers the correct ways'
  );
});
