import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

let oldI18n;

moduleForComponent('i18n-split-string', 'helper:i18n-split-string', {
  beforeEach() {
    oldI18n = window.i18n;
  },
  afterEach() {
    window.i18n = oldI18n;
  }
});

test('splits translation', function (assert) {
  let translated = '|salsa| verde';
  window.i18n = function() {
    return translated;
  };

  this.set('untranslated', 'green |salsa|');
  this.render(hbs`
    {{#with (i18n-split-string untranslated) as |t|}}
      {{at-index t 0}}%{{at-index t 1}}%{{at-index t 2}}
    {{/with}}
  `);

  assert.elementText(this.$(), '%salsa% verde', 'text is translated by i18n-split-string');
});

test('splits translation with substitution', function (assert) {
  let translated = 'test |salsa| verde';
  window.i18n = function() {
    return translated;
  };

  this.set('untranslated', '%{0} green |salsa|');
  this.render(hbs`
    {{#with (i18n-split-string untranslated "test") as |t|}}
      {{at-index t 0}}%{{at-index t 1}}%{{at-index t 2}}
    {{/with}}
  `);

  assert.elementText(this.$(), 'test %salsa% verde', 'text is translated by i18n-split-string');
});
