import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

let oldI18n;

moduleForComponent('i18n', 'helper:i18n', {
  beforeEach() {
    oldI18n = window.i18n;
  },
  afterEach() {
    window.i18n = oldI18n;
  }
});

test('translates a string with the window.i18n function', function (assert) {
  let translated = 'Bonjour';
  window.i18n = function() {
    return translated;
  };

  this.set('untranslated', 'Howdy');
  this.render(hbs`{{i18n untranslated}}`);
  assert.equal(this.$().text(), translated, 'text is translated by window.i18n');
});

test('emits a blank string for undefined input', function (assert) {
  this.set('untranslated', undefined);
  this.render(hbs`{{i18n untranslated}}`);
  assert.equal(this.$().text(), '', 'undefined input is displayed as blank');
});
