import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('helpers:percent-progress');

test('showing a percentage', function(assert) {
  this.render(hbs`{{percent-progress 1 3}}`);

  assert.equal(this.$().text().trim(), '33%', 'shows rounded percentage');
});

test('with non-numeric numerator', function(assert) {
  this.render(hbs`{{percent-progress 'hi' 3}}`);

  assert.equal(this.$().text().trim(), '', 'returns empty string');
});

test('with non-numeric denominator', function(assert) {
  this.render(hbs`{{percent-progress 3 nothing}}`);

  assert.equal(this.$().text().trim(), '', 'returns empty string');
});

test('with zero numerator', function(assert) {
  this.render(hbs`{{percent-progress 0 3}}`);

  assert.equal(this.$().text().trim(), '0%', 'returns 0%');
});

test('with zero denominator', function(assert) {
  this.render(hbs`{{percent-progress 3 0}}`);

  assert.equal(this.$().text().trim(), '0%', 'returns 0%');
});
