import { moduleForComponent } from 'ember-qunit';
import test from 'ember-sinon-qunit/test-support/test';
import hbs from 'htmlbars-inline-precompile';
import { createMockRouter } from 'web-client/tests/helpers/mock-routing-service';

moduleForComponent('route-for', 'helper:route-for', {
  integration: true,
  beforeEach() {
    this.register('service:-routing', createMockRouter(() => '/generated/path'));
  }
});

test('should render a relative path', function(assert) {
  this.render(hbs `
    <strong>URL</strong>: <span id='url'>{{route-for 'vod' 'testUser' '123'}}</span>
  `);
  assert.elementText('#url', '/generated/path', 'should return a relative path');
});

test('should render a absolute path', function(assert) {
  this.render(hbs `
    <strong>URL</strong>: <span id='url'>{{route-for 'user.home' 'testUser' absolute=true}}</span>
  `);
  assert.elementText('#url', `${location.origin}/generated/path`,
    `should return a URL containing the origin '${location.origin}'`);
});
