import { module, test } from 'qunit';
import run from 'ember-runloop';
import wait from 'ember-test-helpers/wait';
import { initialize } from 'web-client/instance-initializers/time-spent-monitor';
import TimeSpentClient from 'web-client/services/time-spent-client';
import MockTrackingService from 'web-client/tests/helpers/mock-tracking-service';
import { createMockRouter } from 'web-client/tests/helpers/mock-routing-service';
import startApp from '../../helpers/start-app';
import destroyApp from '../../helpers/destroy-app';
import { timeSpentEventAsserter } from '../../unit/services/time-spent-client-test';

module("Unit | Instance Initializer | time spent monitor", {
  beforeEach () {
    run(() => {
      this.application = startApp();
      this.owner = this.application.buildInstance();
      this.owner.register('service:tracking', MockTrackingService);
      this.owner.register('service:-routing', createMockRouter(() => '/directory/following'));
      this.owner.lookup('service:-routing').set('currentRouteName', TimeSpentClient.proto().ENABLED_ROUTES[0]);
      this.client = this.owner.lookup('service:time-spent-client');
    });
  },
  afterEach () {
    run(this.owner, 'destroy');
    destroyApp(this.application);
  }
});

test("it starts monitoring for time spent", function (assert) {
  assert.expect(4);

  initialize(this.owner);

  return wait()
    .then(() => {
      assert.trackEvent('time_spent', timeSpentEventAsserter(assert));
    });
});
