import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import run from 'ember-runloop';
import { underscore } from 'ember-string';
let id = 'twitch';

moduleForIntegration('channel', 'Integration | Models | Channel', {
  beforeEach(assert) {
    this.store = this.container.lookup('service:store');
    let channelData = this.server.create('channel-ember-data', { display_name: 'Twitch', mature: true, _id: 1 });
    assert.hasProp = function(channel, prop) {
      this.ok(channel.get(prop), `property ${prop} present on channel`);
      this.equal(channel.get(prop), channelData[underscore(prop)], `channel serializes ${prop}`);
    };
  }
});

test('can fetch channel', function(assert) {
  assert.expect(30); // 2x assertions
  let done = assert.async();

  run(() => {
    return this.store.findRecord('channel', id);
  }).then(channel => {
    assert.hasProp(channel, '_id');
    assert.hasProp(channel, 'broadcasterLanguage');
    assert.hasProp(channel, 'delayControlsEnabled');
    assert.hasProp(channel, 'displayName');
    assert.hasProp(channel, 'game');
    assert.hasProp(channel, 'logo');
    assert.hasProp(channel, 'mature');
    assert.hasProp(channel, 'name');
    assert.hasProp(channel, 'primaryTeamDisplayName');
    assert.hasProp(channel, 'primaryTeamName');
    assert.hasProp(channel, 'profileBanner');
    assert.hasProp(channel, 'showChat');
    assert.hasProp(channel, 'status');
    assert.hasProp(channel, 'videoBanner');
    assert.hasProp(channel, 'views');

    done();
  });
});
