import Ember from 'ember';
import { moduleFor, test } from 'ember-qunit';
import DepChannelModel from 'web-client/models/deprecated-channel';
import { setOwnerInjection } from 'web-client/utilities/owner-injection';
import {
  setup as setupMirage,
  teardown as teardownMirage
} from '../../helpers/setup-mirage-for-integration';
import wait from 'ember-test-helpers/wait';

const { getOwner } = Ember;

moduleFor('Integration | Model | deprecated-channel', {
  integration: true,
  beforeEach() {
    setupMirage(this);
    let owner = getOwner(this);
    setOwnerInjection(owner.ownerInjection());
  },

  afterEach() {
    teardownMirage(this);
  }
});

test('loading viewer for channel', function(assert) {
  assert.expect(4);

  this.viewer = this.server.create('channel-viewer', {steam_id: '2342'});
  this.channel = this.server.create('channel-ember-data', {name: 'twitch'});

  assert.notEqual(this.viewer, null, 'precond - should have non-null viewer');
  assert.notEqual(this.channel, null, 'precond - should have non-null channel');
  assert.equal(this.viewer.steam_id, '2342', 'precond - should have passed-in steam id');
  let dcm = DepChannelModel.find({ id: this.channel.name });

  return dcm.load().then(() => {
    dcm.get('viewer'); // There is a side-effect kicking off `load`
    return wait();
  }).then(() => {
    assert.equal(dcm.get('viewer.steam_id'), this.viewer.steam_id, 'steam id should be loaded on channel viewer');
  });
});
