import run from 'ember-runloop';
import { test } from 'ember-qunit';
import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import videoScenario from 'web-client/mirage/scenarios/video';
import DeprecatedVideo from 'web-client/models/deprecated-video';
import { ARCHIVE_TYPE_PARAM, UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';

const VIDEO_OPTIONS = {
  broadcast_type: UPLOAD_TYPE_PARAM,
  published_at: null
};

moduleForIntegration('deprecated-video', 'Integration | Models | deprecated-video', {
  beforeEach() {
    let video = videoScenario(this.server, VIDEO_OPTIONS);

    return DeprecatedVideo.findOne(`v${video.id}`).load(true).then(videoModel => {
      this.video = videoModel;
    });
  }
});

test('wasUploaded when video is an upload', function(assert) {
  assert.ok(this.video.get('wasUploaded'), 'should be true');
});

test('wasUploaded when video is not an upload', function(assert) {
  this.video.set('broadcast_type', ARCHIVE_TYPE_PARAM);
  assert.notOk(this.video.get('wasUploaded'), 'should be false');
});

test('when published_at is null', function(assert) {
  assert.expect(1);

  let recordedDate = this.video.created_at;
  assert.equal(this.video.get('recordedDate'), recordedDate, 'recordedDate set to created_at');
});

test('when published_at is not null', function(assert) {
  assert.expect(1);
  let video = videoScenario(this.server);
  return run(() => {
    return DeprecatedVideo.findOne(`v${video.id}`).load(true);
  }).then((videoModel) => {
    let recordedDate = videoModel.published_at;
    assert.equal(videoModel.get('recordedDate'), recordedDate, 'recordedDate set to published_at');
  });
});

