import { moduleForModel, test } from 'ember-qunit';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import run from 'ember-runloop';

/* Example response:

const createResponse = {
  "_id": "5",
  "channel_id": "117634199",
  "start_time": "2017-02-22T16:30:00Z",
  "end_time": "2017-02-22T17:30:00Z",
  "time_zone_id": "America\/Los_Angeles",
  "title": "My Event",
  "description": "Because it's so good!",
  "game_id": 31750,
  "channel": {
    "mature": false,
    "status": "My first broadcast #gamedev",
    "broadcaster_language": "hu",
    "display_name": "mitchlloyd",
    "game": "Creative",
    "language": "en",
    "_id": 117634199,
    "name": "mitchlloyd",
    "created_at": "2016-03-03T19:56:23.944146Z",
    "updated_at": "2017-02-17T22:35:41.411308Z",
    "partner": false,
    "logo": null,
    "video_banner": null,
    "profile_banner": null,
    "profile_banner_background_color": "",
    "url": "https:\/\/www.twitch.tv\/mitchlloyd",
    "views": 274,
    "followers": 4
  },
  "game": {
    "name": "Arma 3",
    "popularity": 7886,
    "_id": 31750,
    "giantbomb_id": 35383,
    "box": {
      "large": "https:\/\/static-cdn.jtvnw.net\/ttv-boxart\/Arma%203-272x380.jpg",
      "medium": "https:\/\/static-cdn.jtvnw.net\/ttv-boxart\/Arma%203-136x190.jpg",
      "small": "https:\/\/static-cdn.jtvnw.net\/ttv-boxart\/Arma%203-52x72.jpg",
      "template": "https:\/\/static-cdn.jtvnw.net\/ttv-boxart\/Arma%203-{width}x{height}.jpg"
    },
    "logo": {
      "large": "https:\/\/static-cdn.jtvnw.net\/ttv-logoart\/Arma%203-240x144.jpg",
      "medium": "https:\/\/static-cdn.jtvnw.net\/ttv-logoart\/Arma%203-120x72.jpg",
      "small": "https:\/\/static-cdn.jtvnw.net\/ttv-logoart\/Arma%203-60x36.jpg",
      "template": "https:\/\/static-cdn.jtvnw.net\/ttv-logoart\/Arma%203-{width}x{height}.jpg"
    }
  }
};
*/

moduleForModel('event', 'Integration | Models | event', {
  integration: true,

  beforeEach() {
    setupMirage(this);
  },

  afterEach() {
    teardownMirage(this);
  }
});

test('creating an event', function(assert) {
  assert.expect(10);

  this.server.logging = true;
  let serverChannel = this.server.create('channel', { _id: 54321, name: 'channelName' });
  let serverGame = this.server.create('game', { _id: 4321 });

  return run(() => {
    return this.store().findRecord('channel', 'channelName');
  }).then(channel => {
    return this.store().createRecord('event', {
      title: 'Event Title',
      description: 'Event description.',
      startTime: new Date('2017-02-22T16:30:00.000Z'),
      endTime: new Date('2017-02-23T16:30:00.000Z'),
      timeZoneId: "America/Los_Angeles",
      gameId: serverGame._id,
      channel
    }).save();
  }).then(event => {
    /* Check the normalized attributes on the client */

    let eventId = event.get('id');

    assert.deepEqual(event.get('game.boxImage'), serverGame.box, 'game box art data cached');
    assert.deepEqual(event.get('game.logoImage'), serverGame.logo, 'logo art data cached');

    assert.deepEqual(event.get('channel.name'), serverChannel.name, 'channel data cached');

    /* Check the saved attributes on the server */

    let serverEvent = this.server.schema.events.find(eventId);

    assert.equal(serverEvent.title, 'Event Title', 'saves the title');
    assert.equal(serverEvent.description, 'Event description.', 'saves the description');
    assert.equal(serverEvent.start_time, '2017-02-22T16:30:00.000Z', 'saves the startTime');
    assert.equal(serverEvent.end_time, '2017-02-23T16:30:00.000Z', 'saves the endTime');
    assert.equal(serverEvent.time_zone_id, 'America/Los_Angeles', 'saves the time zone');

    assert.equal(serverEvent.gameId, serverGame.id, 'sets the related game');
    assert.equal(serverEvent.channelId, serverChannel.id, 'sets the related channel');
  });
});
