import { moduleForModel, test } from 'ember-qunit';
import {
  setup as setupMirage,
  teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import run from 'ember-runloop';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForModel('friends-list-user', 'Integration | Models | friends-list-user', {
  integration: true,
  beforeEach() {
    setupMirage(this);
    this.user = stubLogin();
  },
  afterEach() {
    teardownMirage(this);
  }
});

test('can fetch recommended friends', function(assert) {
  assert.expect(3);

  let friendLogin = 'Willy Mantle';
  let recommendedReason = 'whispered'; // maps to "You've whispered them"
  this.server.create('friends-list-user', {
    login: friendLogin,
    recommendedReason
  });
  this.server.create('friends-list-user');

  return run(() => {
    return this.store().query('friends-list-user', {
      login: this.user.login,
      type: 'recommended'
    });
  }).then((friends) => {
    assert.equal(friends.get('length'), 2, 'two friends provided');
    let friend = friends.get('firstObject');
    assert.equal(
      friend.get('login'), friendLogin,
      'login is present on the friend model');
    assert.equal(
      friend.get('recommendedReason'), "You've whispered them",
      'recommendedReason is set on the model');
  });
});
