import run from 'ember-runloop';
import { test } from 'ember-qunit';
import moduleForModel from 'web-client/tests/helpers/module-for-model';

let image1x = 'image/64_1x.jpg';
let image2x = 'image/128_2x.jpg';
let originalWindowdevicePixelRatio = window.devicePixelRatio;

moduleForModel('offer-asset', 'Integration | Models | offer-asset', {
  afterEach() {
    window.devicePixelRatio = originalWindowdevicePixelRatio;
  }
});

test('displays retina images on retina devices', function(assert) {
  assert.expect(1);

  window.devicePixelRatio = 2;

  return run(() => {
    let offerAsset = this.subject({
      location:   image1x,
      location2x: image2x
    });
    assert.equal(offerAsset.get('locationUrl'), image2x, 'retina image url for retina devises');
  });
});

test('displays low res images on non retina devices', function(assert) {
  assert.expect(1);

  window.devicePixelRatio = 1;

  return run(() => {
    let offerAsset = this.subject({
      location:   image1x,
      location2x: image2x
    });
    assert.equal(offerAsset.get('locationUrl'), image1x, 'low res image url for NON retina devises');
  });
});
