import { skip } from 'ember-qunit';
import run from 'ember-runloop';
import RSVP from 'rsvp';
import moduleForModel from 'web-client/tests/helpers/module-for-model';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import playlistScenario from 'web-client/mirage/scenarios/video-playlist';
import Video from 'web-client/models/video';
import { buildItemID, extractIDMeta } from 'web-client/utilities/video/playlist-item';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

moduleForModel('video-playlist-item', 'Integration | Models | video-playlist-item', {
  integration: true,
  beforeEach() {
    setupMirage(this);
    this.playlist = playlistScenario(this.server);
  },
  afterEach() {
    teardownMirage(this);
  }
});

skip('buildItemId', function(assert) {
  assert.equal(buildItemID('foo', '123'), 'foo/123', 'should format properly');
});

skip('extractIDMeta', function(assert) {
  let id = buildItemID('foo', '123');
  assert.deepEqual(extractIDMeta(id), {
    id: '123',
    type: 'foo'
  }, 'should extract the id and type');
});

skip('looking up a playlist item record', function(assert) {
  assert.expect(7);

  return run(() => {
    return this.store().findRecord('video-playlist', this.playlist.id);
  }).then((playlist) => {
    return playlist.get('items');
  }).then((items) => {
    assert.equal(items.length, this.playlist.items.length, 'should not be empty');
    return items.get('firstObject');
  }).then((item) => {
    assert.equal(item.get('position'), 0, 'should have the correct position');
    return RSVP.hash({
      playlist: item.get('playlist'),
      video: item.get('video')
    });
  }).then(({ playlist, video }) => {
    assert.equal(playlist.get('id'), this.playlist.id, 'should properly setup playlist relationship for item');
    assert.ok(video instanceof Video, 'should be a video model');

    let mirageVideo = this.server.db.videos.where({ _id: this.playlist.items[0].id })[0];
    assert.ok(mirageVideo, 'corresponding video should exist in mirage');
    assert.equal(
      video.get('id'),
      normalizeVideoId(mirageVideo._id),
      // normalizeVideoId(this.playlist.items[0].id),
      'video relationship ID should be set properly'
    );
    assert.equal(
      video.get('title'),
      mirageVideo.title,
      'should properly setup relationship attributes'
    );
  });
});
