import moduleForModel from 'web-client/tests/helpers/module-for-model';
import { test } from 'ember-qunit';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import run from 'ember-runloop';

const ID = 'dansgaming';

moduleForModel('video-stats/channel-lifetime', 'Integration | Models | video-stats/channel-lifetime', {
  beforeEach() {
    setupMirage(this);

    return run(() => {
      return this.store().findRecord('video-stats/channel-lifetime', ID);
    }).then(channelLifetime => {
      this.subject = channelLifetime;
    });
  },

  afterEach() {
    teardownMirage(this);
  }
});

test('can fetch user', function(assert) {
  assert.equal(this.subject.id, ID, "should have the correct ID");
  assert.equal(this.subject.get('analytics').length, 3, "should have analytics data");
});

test('averageDuration', function(assert) {
  assert.equal(this.subject.get('averageDuration'), 15, 'Should properly find the correct view duration');
});

test('minutesWatched', function(assert) {
  assert.equal(this.subject.get('minutesWatched'), 450, 'Should properly find the correct minutes watched');
});

test('viewCount', function(assert) {
  assert.equal(this.subject.get('viewCount'), 30, 'Should properly find the correct view count');
});

test('getAnalyticsByFilter for an unknown filter type', function(assert) {
  let result = this.subject.getAnalyticsByFilter('badfilter');
  assert.deepEqual(result, [], 'getAnalyticsByFilter should properly handle non-existent filters');
});

test('getAnalyticsByFilter for a specified filter type', function(assert) {
  let result = this.subject.getAnalyticsByFilter('country');

  assert.equal(result.length, 2, 'returns 2 rows');

  assert.deepEqual(result.find(r => r.key === 'Canada'), {
    key: 'Canada',
    averageviewduration: 5,
    minuteswatched: 450
  }, 'shows correct statistic for Canada');

  assert.deepEqual(result.find(r => r.key === 'USA'), {
    key: 'USA',
    averageviewduration: 10,
    viewcount: 30
  }, 'shows correct statistics for USA');
});
