import { test } from 'ember-qunit';
import moduleForModel from 'web-client/tests/helpers/module-for-model';
import videoScenario from 'web-client/mirage/scenarios/video';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import run from 'ember-runloop';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';

moduleForModel('video', 'Integration | Models | video', {
  integration: true,
  beforeEach() {
    setupMirage(this);
    this.video = videoScenario(this.server);
  },
  afterEach() {
    teardownMirage(this);
  }
});

test('finding a video record', function(assert) {
  assert.expect(6);

  return run(() => {
    return this.store().findRecord('video', this.video.id);
  }).then((video) => {
    assert.equal(video.id, this.video.id, 'should properly serialize the ID');
    assert.equal(video.get('length'), this.video.length, 'should properly serialize a simple attr');
    assert.equal(video.get('createdAt'), this.video.created_at, 'should properly serialize a snake_case attr');
    assert.equal(video.get('type'), ARCHIVE_TYPE_PARAM, 'should normalize broadcast_type => type');

    return video.get('channel');
  }).then((channel) => {
    assert.equal(channel.id, this.video.channel.name, 'should set the correct channel relationship id');
    assert.equal(channel.get('broadcasterLanguage'), 'en', 'should be able to retrieve channel info');
  });
});


test('when published_at is null', function(assert) {
  assert.expect(1);

  this.video.published_at = null;
  this.video.save();

  return run(() => {
    return this.store().findRecord('video', this.video.id);
  }).then((video) => {
    let recordedDate = this.video.created_at;
    assert.equal(video.get('recordedDate'), recordedDate, 'recordedDate set to created_at');
  });
});

test('when published_at is not null', function(assert) {
  assert.expect(1);

  return run(() => {
    return this.store().findRecord('video', this.video.id);
  }).then((video) => {
    let recordedDate = this.video.published_at;
    assert.equal(video.get('recordedDate'), recordedDate, 'recordedDate set to published_at');
  });
});

