import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'qunit';
import VodAppeal from 'web-client/models/vod-appeal';
import RSVP from 'rsvp';
import appealsInitializer from 'web-client/instance-initializers/ember-vod-appeals';

moduleForIntegration('Integration | Models | vod-appeal');

test('identity map', function(assert) {
  assert.expect(2);

  appealsInitializer.initialize(this.owner);

  let appeals = this.server.createList('vod-appeal', 2);

  return RSVP.all([
    VodAppeal.find(this.owner, appeals[0].id),
    VodAppeal.find(this.owner, appeals[1].id)
  ]).then((appealModels) => {
    assert.notStrictEqual(appealModels[0], appealModels[1], 'finding a VodAppeal returns a new object');

    // Re-fetch the first model
    return RSVP.hash({
      refetchedModel: VodAppeal.find(this.owner, appeals[0].id),
      appealModels
    });
  }).then(({ refetchedModel, appealModels }) => {
    assert.strictEqual(refetchedModel, appealModels[0], 'same object is reused');
  });
});

