import { moduleForModel, test } from 'ember-qunit';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import run from 'ember-runloop';

moduleForModel('channel', 'Integration | Serializer | Channel', {
  integration: true,
  beforeEach() {
    setupMirage(this);

    this.pushModel = channelEmberData => {
      let store = this.container.lookup('service:store');
      let serializer = store.serializerFor('channel');
      let data = serializer.normalizeResponse(store, 'channel', channelEmberData, null, 'findRecord');
      return store.push(data);
    };
  },

  afterEach() {
    teardownMirage(this);
  }
});

test('channel serializes properties', function(assert) {
  assert.expect(5);

  run(() => {
    let channel = this.server.create('channel-ember-data', { profile_banner_background_color: '#112233' });
    let model = this.pushModel(channel);

    [
      [ 'display_name', 'displayName' ],
      [ 'logo', 'logo' ],
      [ 'name', 'name' ],
      [ 'profile_banner', 'profileBanner' ],
      [ 'profile_banner_background_color', 'profileBannerBackgroundColor' ]
    ]
    .forEach(([ dataKey, property ]) => {
      assert.equal(channel[dataKey], model.get(property), `parsed ${property}`);
    });
  });
});
