import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';

moduleForModel('extension-installation', 'Integration | Serializer | extension-installation', {
  integration: true,
  beforeEach() {
    this.store = this.container.lookup('service:store');
    this.serializer = this.store.serializerFor('extension-installation');
  }
});

test('extension-installation serializes from backend', function(assert) {
  assert.expect(5);

  run(() => {
    let extensionPayload = {
      extensions: [
        {
          id: '1',
          name: 'My Awesome Extension',
          summary: 'This is the best extension ever'
        }
      ],
      actives: [
        {
          extension_id: '1',
          config: "{}"
        }
      ],
      tokens: [
        {
          extension_id: '1',
          token: '1234'
        }
      ]
    };

    let data = this.serializer.normalizeResponse(this.store, 'extension-installation', extensionPayload, null, 'query');
    let model = this.store.push(data);

    assert.ok(model);

    [
      [ 'extension.name', 'My Awesome Extension' ],
      [ 'extension.summary', 'This is the best extension ever' ],
      [ 'token', '1234' ],
      [ 'active', true ]
    ]
    .forEach(([ property, expected ]) => {
      assert.equal(model[0].get(property), expected, `parsed ${property}`);
    });
  });
});
