import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';
import { EXTENSION_ID_VERSION_SEPARATOR } from 'web-client/adapters/extension';

moduleForModel('extension', 'Integration | Serializer | extension', {
  integration: true,
  beforeEach() {
    this.store = this.container.lookup('service:store');
    this.serializer = this.store.serializerFor('extension');
  }
});

test('extension serializes from backend', function(assert) {
  assert.expect(6);

  run(() => {
    let extensionPayload = {
      extensions: [
        {
          id: '1',
          version: '0.1.0',
          name: 'My Awesome Extension',
          summary: 'This is the best extension ever'
        }
      ]
    };

    let data = this.serializer.normalizeResponse(this.store, 'extension', extensionPayload, null, 'findAll');
    let model = this.store.push(data);

    assert.ok(model);

    [
      [ 'clientId', '1' ],
      [ 'version', '0.1.0'],
      [ 'id', `1${EXTENSION_ID_VERSION_SEPARATOR}0.1.0` ],
      [ 'name', 'My Awesome Extension' ],
      [ 'summary', 'This is the best extension ever' ]
    ]
    .forEach(([ property, expected ]) => {
      assert.equal(model[0].get(property), expected, `parsed ${property}`);
    });
  });
});
